/*
 * Decompiled with CFR 0.152.
 */
package cayleytable;

import cayleytable.groupMatrix;
import cayleytable.groupPanel;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class groupTableModel
extends AbstractTableModel {
    private int order = 0;
    private boolean canEditTable = false;
    private ArrayList<ArrayList<String>> tableRows = new ArrayList();
    private groupPanel topPanel;

    public groupTableModel(groupPanel inputPanel) {
        this.topPanel = inputPanel;
    }

    public void displayTable(groupMatrix matrix, boolean makeEditable) {
        this.order = matrix.getOrder();
        this.canEditTable = makeEditable;
        this.tableRows.clear();
        this.tableRows = new ArrayList(this.order);
        for (int row = 0; row < this.order; ++row) {
            ArrayList<String> tableCols = new ArrayList<String>(this.order + 1);
            while (tableCols.size() < this.order + 1) {
                tableCols.add(Integer.toString(-1));
            }
            for (int col = 0; col < this.order + 1; ++col) {
                if (col == 0) {
                    tableCols.set(col, Integer.toString(row));
                    continue;
                }
                tableCols.set(col, Integer.toString(matrix.getEntry(row, col - 1)));
            }
            this.tableRows.add(row, tableCols);
        }
        this.fireTableChanged(null);
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return null;
        }
        return Integer.toString(column - 1);
    }

    @Override
    public int getRowCount() {
        return this.order;
    }

    @Override
    public int getColumnCount() {
        return this.order + 1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            int value = Integer.decode((String)aValue);
            if (value < 0 || value >= this.order) {
                return;
            }
            this.topPanel.changeValueInGroup(rowIndex, columnIndex - 1, value);
        }
        catch (NumberFormatException e) {
            return;
        }
        ArrayList<String> tableCols = this.tableRows.get(rowIndex);
        tableCols.set(columnIndex, (String)aValue);
        this.tableRows.set(rowIndex, tableCols);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ArrayList<String> tableCols = this.tableRows.get(rowIndex);
        if (tableCols.get(columnIndex) == "-1") {
            return "";
        }
        return tableCols.get(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.canEditTable) {
            return columnIndex != 0;
        }
        return false;
    }
}

