/*
 * Decompiled with CFR 0.152.
 */
package cayleytable;

import java.util.ArrayList;
import java.util.Arrays;

public class groupMatrix {
    private ArrayList<ArrayList<String>> matrixRows = new ArrayList();
    private int order;

    public groupMatrix() {
        this.order = 0;
        for (int row = 0; row < this.order; ++row) {
            ArrayList<String> matrixCols = new ArrayList<String>();
            for (int col = 0; col < this.order; ++col) {
                matrixCols.add("-1");
            }
            this.matrixRows.add(matrixCols);
        }
    }

    public groupMatrix(int n) {
        this.order = n;
        for (int row = 0; row < this.order; ++row) {
            ArrayList<String> matrixCols = new ArrayList<String>();
            for (int col = 0; col < this.order; ++col) {
                matrixCols.add("-1");
            }
            this.matrixRows.add(matrixCols);
        }
    }

    public void resetGroup(groupMatrix reset) {
        this.resetSize(reset.getOrder());
        for (int row = 0; row < this.order; ++row) {
            for (int col = 0; col < this.order; ++col) {
                this.setEntry(row, col, reset.getEntry(row, col));
            }
        }
    }

    public boolean isEqual(groupMatrix check) {
        if (this.order != check.getOrder()) {
            return false;
        }
        for (int row = 0; row < this.order; ++row) {
            for (int col = 0; col < this.order; ++col) {
                if (this.getEntry(row, col) == check.getEntry(row, col)) continue;
                return false;
            }
        }
        return true;
    }

    public void resetSize(int size) {
        this.matrixRows.clear();
        this.order = size;
        for (int row = 0; row < this.order; ++row) {
            ArrayList<String> matrixCols = new ArrayList<String>();
            try {
                for (int col = 0; col < this.order; ++col) {
                    matrixCols.add("-1");
                }
                this.matrixRows.add(matrixCols);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                System.out.println("Error Index out of Bounds:  " + e.getMessage());
            }
        }
    }

    public void setEntry(int row, int col, int value) {
        ArrayList<String> matrixCols = this.matrixRows.get(row);
        matrixCols.set(col, Integer.toString(value));
        this.matrixRows.set(row, matrixCols);
    }

    public int getEntry(int row, int col) {
        ArrayList<String> matrixCols = this.matrixRows.get(row);
        return Integer.decode(matrixCols.get(col));
    }

    public boolean checkComplete() {
        for (int row = 0; row < this.order; ++row) {
            for (int col = 0; col < this.order; ++col) {
                ArrayList<String> matrixCols = this.matrixRows.get(row);
                if (matrixCols.get(col) != null) continue;
                return false;
            }
        }
        return true;
    }

    public int getOrder() {
        return this.order;
    }

    public int findIdentity() {
        if (!this.checkForIdentity()) {
            return -1;
        }
        for (int row = 0; row < this.order; ++row) {
            int col;
            for (col = 0; col < this.order && this.getEntry(row, col) == col; ++col) {
            }
            if (col < this.order) continue;
            return row;
        }
        return -1;
    }

    public int findInverse(int element) {
        int identity = this.findIdentity();
        for (int row = 0; row < this.order; ++row) {
            if (this.getEntry(row, element) != identity) continue;
            return row;
        }
        return this.order + 1;
    }

    public boolean checkForIdentity() {
        int row;
        int columnID = -1;
        int rowID = -1;
        for (row = 0; row < this.order; ++row) {
            int col;
            for (col = 0; col < this.order && this.getEntry(row, col) == col; ++col) {
            }
            if (col < this.order) continue;
            rowID = row;
            break;
        }
        if (rowID < 0) {
            return false;
        }
        for (columnID = 0; columnID < this.order && this.getEntry(0, columnID) != 0; ++columnID) {
        }
        if (columnID >= this.order) {
            return false;
        }
        for (row = 1; row < this.order; ++row) {
            if (this.getEntry(row, columnID) == row) continue;
            return false;
        }
        return rowID == columnID;
    }

    public boolean checkForInverse() {
        int identity = this.findIdentity();
        if (identity == -1) {
            return false;
        }
        for (int row = 0; row < this.order; ++row) {
            int inverse = this.findInverse(row);
            if (inverse >= this.order) {
                return false;
            }
            if (this.getEntry(inverse, row) == identity) continue;
            return false;
        }
        return true;
    }

    public boolean checkIfAssociative() {
        for (int x = 0; x < this.order; ++x) {
            for (int y = 0; y < this.order; ++y) {
                for (int z = 0; z < this.order; ++z) {
                    if (this.getEntry(x, this.getEntry(y, z)) == this.getEntry(this.getEntry(x, y), z)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean checkIfCommutative() {
        for (int x = 0; x < this.order; ++x) {
            for (int y = 0; y < this.order; ++y) {
                if (this.getEntry(x, y) == this.getEntry(y, x)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkForUniquenessInRowAndCol() {
        for (int row = 0; row < this.order; ++row) {
            int[] rowArray = new int[this.order];
            for (int col = 0; col < this.order; ++col) {
                rowArray[col] = this.getEntry(row, col);
            }
            if (this.checkArray(rowArray, this.order)) continue;
            return false;
        }
        for (int col = 0; col < this.order; ++col) {
            int[] colArray = new int[this.order];
            for (int row = 0; row < this.order; ++row) {
                colArray[row] = this.getEntry(row, col);
            }
            if (this.checkArray(colArray, this.order)) continue;
            return false;
        }
        return true;
    }

    private boolean checkArray(int[] values, int size) {
        Arrays.sort(values);
        for (int i = 0; i < size - 1; ++i) {
            if (values[i] != values[i + 1]) continue;
            return false;
        }
        return true;
    }
}

