/*
 * Decompiled with CFR 0.152.
 */
package cayleytable;

import cayleytable.groupCreator;
import cayleytable.groupIdentify;
import cayleytable.groupMatrix;
import cayleytable.groupPanel;
import cayleytable.groupRelation;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class groupMain
extends JFrame {
    private JButton btnCheckAbel;
    private JButton btnCheckGroup;
    private JButton btnCheckName;
    private JButton btnDefRelnGroup;
    private JButton btnInnerAut;
    private JButton btnUserDefinedGroup;
    private JButton btnXProdGroup;
    private JButton btnZnGroup;
    private groupIdentify groupNamer;
    private JLabel lblGeneratorButtons;
    private JLabel lblGroupName;
    private JLabel lblPropertyButtons;
    private JLabel lblResultsOfAnalysis;
    private groupCreator myCreator;
    private groupPanel myGroup;
    private boolean blnGroupCreated;

    public groupMain() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    groupMain.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Error: " + ex.getLocalizedMessage());
        }
    }

    private void initComponents() {
        this.groupNamer = new groupIdentify();
        this.myCreator = new groupCreator();
        this.lblGroupName = new JLabel();
        this.myGroup = new groupPanel();
        this.lblResultsOfAnalysis = new JLabel();
        this.lblPropertyButtons = new JLabel();
        this.btnCheckGroup = new JButton();
        this.btnCheckAbel = new JButton();
        this.btnCheckName = new JButton();
        this.btnInnerAut = new JButton();
        this.lblGeneratorButtons = new JLabel();
        this.btnZnGroup = new JButton();
        this.btnXProdGroup = new JButton();
        this.btnUserDefinedGroup = new JButton();
        this.btnDefRelnGroup = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblGroupName.setHorizontalAlignment(0);
        this.lblGroupName.setText(this.groupNamer.getName());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.lblGroupName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.myGroup, gridBagConstraints);
        this.lblResultsOfAnalysis.setHorizontalAlignment(0);
        this.lblResultsOfAnalysis.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.lblResultsOfAnalysis, gridBagConstraints);
        this.lblPropertyButtons.setHorizontalAlignment(2);
        this.lblPropertyButtons.setText("Check Group Properties:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.lblPropertyButtons, gridBagConstraints);
        this.btnCheckGroup.setText("Check if Group");
        this.btnCheckGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                groupMain.this.checkIfGroup(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.btnCheckGroup, gridBagConstraints);
        this.btnCheckAbel.setText("Check if Abelian");
        this.btnCheckAbel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                groupMain.this.checkIfAbelian(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.btnCheckAbel, gridBagConstraints);
        this.btnCheckName.setText("Find Group Name");
        this.btnCheckName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                groupMain.this.findGroupName(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.btnCheckName, gridBagConstraints);
        this.btnInnerAut.setText("Find Inner Automorphism");
        this.btnInnerAut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                groupMain.this.createInnerAutGroup(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.btnInnerAut, gridBagConstraints);
        this.lblGeneratorButtons.setHorizontalAlignment(2);
        this.lblGeneratorButtons.setText("Choose Type of Group to Enter:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.lblGeneratorButtons, gridBagConstraints);
        this.btnZnGroup.setText("Cyclic Group");
        this.btnZnGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                groupMain.this.createZnGroup(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.btnZnGroup, gridBagConstraints);
        this.btnXProdGroup.setText("Cross Product Group");
        this.btnXProdGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                groupMain.this.createXProdGroup(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.btnXProdGroup, gridBagConstraints);
        this.btnUserDefinedGroup.setText("User Defined Group");
        this.btnUserDefinedGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                groupMain.this.createUserEntryGroup(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.btnUserDefinedGroup, gridBagConstraints);
        this.btnDefRelnGroup.setText("Defined Relationship Group");
        this.btnDefRelnGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                groupMain.this.createDefinedRelationshipGroup(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.btnDefRelnGroup, gridBagConstraints);
    }

    private void createDefinedRelationshipGroup(ActionEvent evt) {
        ArrayList<String> generatorList = new ArrayList<String>();
        ArrayList<groupRelation> definedRelationships = new ArrayList<groupRelation>();
        String defRelName = "Group Table:  Defined Relationship";
        String defRelString = JOptionPane.showInputDialog(null, "Enter the number of generators in the defined relationship. ", "Defined Relationship Dialog", 3);
        int defRelNumOfGenerators = -1;
        try {
            defRelNumOfGenerators = Integer.parseInt(defRelString, 10);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, defRelString + " is not a legal number!\nError: " + e.getMessage(), "Number Error", 0);
            this.blnGroupCreated = false;
            return;
        }
        int numRelationships = this.factorial(defRelNumOfGenerators);
        System.out.println("Defining Relationships");
        if (defRelNumOfGenerators < 2) {
            JOptionPane.showMessageDialog(null, "You cannot create a defined relationship with less than two groups.", "Defined Relationship Error", 0);
            this.blnGroupCreated = false;
            return;
        }
        for (int n = 0; n < defRelNumOfGenerators; ++n) {
            String elementString = JOptionPane.showInputDialog(null, "Enter the number of elements in generator " + n, "Element Query Dialog", 3);
            try {
                Integer.parseInt(elementString, 10);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, elementString + " is not a legal number!\nError: " + e.getMessage(), "Number Error", 0);
                --n;
                continue;
            }
            generatorList.add(elementString);
            definedRelationships.add(new groupRelation(n, Integer.parseInt(elementString, 10)));
        }
        boolean extraRelation = true;
        while (extraRelation) {
            String question = JOptionPane.showInputDialog(null, "Do you have an extra relationship between generators?\n  Enter yes/no. ", "Relationship Dialog", 3);
            if ((question = question.toLowerCase()).compareTo("yes") == 0 || question.compareTo("y") == 0) {
                String relationship = JOptionPane.showInputDialog(null, "Enter the extra relationship.", "Relationship Dialog", 3);
                groupRelation extra = new groupRelation(relationship, generatorList);
                boolean foundMatch = false;
                for (int i = 0; i < definedRelationships.size(); ++i) {
                    groupRelation tempRel = definedRelationships.get(i);
                    if (extra.getLeft().compareTo(tempRel.getLeft()) != 0) continue;
                    definedRelationships.set(i, extra);
                    foundMatch = true;
                }
                if (foundMatch) continue;
                definedRelationships.add(extra);
                continue;
            }
            extraRelation = false;
        }
        for (int i = 0; i < defRelNumOfGenerators - 1; ++i) {
            for (int j = i + 1; j < defRelNumOfGenerators; ++j) {
                definedRelationships.add(new groupRelation(j, i, this.getNextRelationship(i, j), generatorList));
            }
        }
        System.out.println("Relationships Defined");
        for (int j = 0; j < definedRelationships.size(); ++j) {
            groupRelation temp = (groupRelation)definedRelationships.get(j);
            System.out.println(j + ": " + temp.getLeft() + " = " + temp.getRight());
        }
        System.out.println("Relationships Defined twice");
        if (this.myCreator.createDefineRelationGroup(generatorList, definedRelationships)) {
            this.myGroup.updateTable(this.myCreator.getGroup(), false);
            System.out.println("Attempting to identify group");
            this.findGroupName(evt);
            this.lblResultsOfAnalysis.setEnabled(false);
            this.lblResultsOfAnalysis.setText("");
            this.blnGroupCreated = true;
        } else {
            this.lblResultsOfAnalysis.setEnabled(true);
            this.lblResultsOfAnalysis.setBackground(Color.white);
            this.lblResultsOfAnalysis.setForeground(Color.RED);
            this.lblResultsOfAnalysis.setText("Error:  No Defined Relationship Group Found");
            System.out.println("No Defined Relationship Group Found");
            this.blnGroupCreated = false;
        }
    }

    private void createUserEntryGroup(ActionEvent evt) {
        String orderString = JOptionPane.showInputDialog(null, "Enter the size of the group you would like to create.", "User Group Dialog", 3);
        int order = 0;
        try {
            order = Integer.parseInt(orderString, 10);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, orderString + " is not a legal number!\nError: " + e.getMessage(), "Number Error", 0);
            return;
        }
        if (order > 1) {
            if (!this.myCreator.createEmptyGroup(order)) {
                JOptionPane.showMessageDialog(null, "Error generating an empty group of order " + orderString + ".\nNO GROUP WAS GENERATED", "Group Generation Error", 0);
            }
            this.myGroup.updateTable(this.myCreator.getGroup(), true);
            this.lblResultsOfAnalysis.setText("");
        } else {
            JOptionPane.showMessageDialog(null, "The group order must be an integer greater than 1.", "Number Error", 0);
        }
        this.lblGroupName.setText("Group Table:  User Defined");
        this.lblResultsOfAnalysis.setEnabled(false);
        this.lblResultsOfAnalysis.setText("");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createXProdGroup(ActionEvent evt) {
        groupMatrix myGroup1 = new groupMatrix(0);
        groupMatrix myGroup2 = new groupMatrix(0);
        String XProdName = "Group Table:  ";
        String XProdString = JOptionPane.showInputDialog(null, "Enter the number of groups in the cross product. ", "Cross Product Dialog", 3);
        int XProdNumOfGroups = -1;
        try {
            XProdNumOfGroups = Integer.parseInt(XProdString, 10);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, XProdString + " is not a legal number!\nError: " + e.getMessage(), "Number Error", 0);
            return;
        }
        if (XProdNumOfGroups <= 1) {
            JOptionPane.showMessageDialog(null, "You cannot create a cross product with less than two groups.", "Cross Product Error", 0);
            return;
        }
        String choice = JOptionPane.showInputDialog(null, "Enter 1 if first group is a Cyclic group, else enter 2 for a Defined Relationship. ", "Cross Product Choice Dialog", 3);
        if (choice.equals("1")) {
            if (!this.createNextCyclicGroup()) return;
            --XProdNumOfGroups;
        } else if (choice.equals("2")) {
            this.createDefinedRelationshipGroup(evt);
            if (!this.blnGroupCreated) return;
            --XProdNumOfGroups;
        } else {
            JOptionPane.showMessageDialog(null, "You must select either a Cyclic group or defined relationship", "Cross Product Error", 0);
            return;
        }
        while (XProdNumOfGroups > 0) {
            myGroup1.resetGroup(this.myCreator.getGroup());
            choice = JOptionPane.showInputDialog(null, "Enter 1 if next group is a Cyclic group, else enter 2 for a Defined Relationship. ", "Cross Product Choice Dialog", 3);
            if (choice.equals("1")) {
                if (!this.createNextCyclicGroup()) return;
                myGroup2.resetGroup(this.myCreator.getGroup());
            } else if (choice.equals("2")) {
                this.createDefinedRelationshipGroup(evt);
                if (!this.blnGroupCreated) return;
                myGroup2.resetGroup(this.myCreator.getGroup());
            } else {
                JOptionPane.showMessageDialog(null, "You must select either a Cyclic group or defined relationship", "Cross Product Error", 0);
                return;
            }
            if (!this.myCreator.createXProdGroup(myGroup1, myGroup2)) {
                JOptionPane.showMessageDialog(null, "Error generating a Cross Product Group.\nNO GROUP WAS GENERATED", "Group Generation Error", 0);
                return;
            }
            --XProdNumOfGroups;
        }
        this.myGroup.updateTable(this.myCreator.getGroup(), false);
        this.findGroupName(evt);
        this.blnGroupCreated = true;
        this.lblResultsOfAnalysis.setEnabled(false);
        this.lblResultsOfAnalysis.setText("");
    }

    private void createZnGroup(ActionEvent evt) {
        if (this.createNextCyclicGroup()) {
            this.myGroup.updateTable(this.myCreator.getGroup(), false);
            this.findGroupName(evt);
            this.blnGroupCreated = true;
        }
        this.lblResultsOfAnalysis.setEnabled(false);
        this.lblResultsOfAnalysis.setText("");
    }

    private void createInnerAutGroup(ActionEvent evt) {
        if (!(this.myCreator.resetGroup(this.myGroup.getGroup()) && this.myCreator.getGroup().checkForIdentity() && this.myCreator.getGroup().checkForInverse() && this.myCreator.getGroup().checkIfAssociative())) {
            JOptionPane.showMessageDialog(null, "Error generating an Inner Automorphism Group.\nRequires Initial Legal Group", "Illegal Group Error", 0);
            return;
        }
        if (this.myCreator.createInnerAutGroup()) {
            this.myGroup.updateTable(this.myCreator.getGroup(), false);
            this.findGroupName(evt);
            this.lblResultsOfAnalysis.setBackground(Color.white);
            this.lblResultsOfAnalysis.setForeground(Color.BLUE);
            this.lblResultsOfAnalysis.setEnabled(true);
            this.lblResultsOfAnalysis.setText("Inner Automorphism Found:  " + this.groupNamer.getName());
        } else {
            this.lblResultsOfAnalysis.setEnabled(true);
            this.lblResultsOfAnalysis.setBackground(Color.white);
            this.lblResultsOfAnalysis.setForeground(Color.RED);
            this.lblResultsOfAnalysis.setText("Error:  No Inner Automorphism Group Found");
            System.out.println("No Inner Automorphism Group Found");
        }
    }

    private void findGroupName(ActionEvent evt) {
        this.lblResultsOfAnalysis.setEnabled(true);
        this.lblGroupName.setEnabled(false);
        this.lblResultsOfAnalysis.setBackground(Color.yellow);
        this.lblResultsOfAnalysis.setForeground(Color.red);
        if (!this.myCreator.resetGroup(this.myGroup.getGroup())) {
            this.lblGroupName.setText("Group Table: This is not a Group");
        } else if (!this.myCreator.getGroup().checkForIdentity()) {
            this.lblGroupName.setText("Group Table: This is not a Group");
        } else if (!this.myCreator.getGroup().checkForInverse()) {
            this.lblGroupName.setText("Group Table: This is not a Group");
        } else if (!this.myCreator.getGroup().checkIfAssociative()) {
            this.lblGroupName.setText("Group Table: This is not a Group");
        } else {
            this.lblResultsOfAnalysis.setEnabled(false);
            this.groupNamer.resetGroupIdentify(this.myCreator.getGroup());
            this.lblGroupName.setEnabled(true);
            this.lblGroupName.setText("Group Table: " + this.groupNamer.getName());
        }
    }

    private void checkIfAbelian(ActionEvent evt) {
        this.lblResultsOfAnalysis.setEnabled(true);
        this.lblResultsOfAnalysis.setBackground(Color.YELLOW);
        this.lblResultsOfAnalysis.setForeground(Color.RED);
        if (!this.myCreator.resetGroup(this.myGroup.getGroup())) {
            this.lblResultsOfAnalysis.setText("The table is not a group because there currently is no table to check!");
        } else if (!this.myCreator.getGroup().checkForIdentity()) {
            this.lblResultsOfAnalysis.setText("The table is not a group because it does not have an identity element");
        } else if (!this.myCreator.getGroup().checkForInverse()) {
            this.lblResultsOfAnalysis.setText("The table is not a group because it does not have an inverse for each element");
        } else if (!this.myCreator.getGroup().checkIfAssociative()) {
            this.lblResultsOfAnalysis.setText("The table is not a group because it is not associative");
        } else if (!this.myCreator.getGroup().checkIfCommutative()) {
            this.lblResultsOfAnalysis.setText("The table is not an Abeliain Group because it is not communative");
        } else {
            this.lblResultsOfAnalysis.setForeground(Color.BLUE);
            this.lblResultsOfAnalysis.setText("The table is an Abelian Group.");
        }
    }

    private void checkIfGroup(ActionEvent evt) {
        this.lblResultsOfAnalysis.setEnabled(true);
        this.lblResultsOfAnalysis.setBackground(Color.yellow);
        this.lblResultsOfAnalysis.setForeground(Color.red);
        if (!this.myCreator.resetGroup(this.myGroup.getGroup())) {
            this.lblResultsOfAnalysis.setText("The table is not a group because there currently is no table to check!");
        } else if (!this.myCreator.getGroup().checkForIdentity()) {
            this.lblResultsOfAnalysis.setText("The table is not a group because it does not have an identity element");
        } else if (!this.myCreator.getGroup().checkForInverse()) {
            this.lblResultsOfAnalysis.setText("The table is not a group because it does not have an inverse for each element");
        } else if (!this.myCreator.getGroup().checkIfAssociative()) {
            this.lblResultsOfAnalysis.setText("The table is not a group because it is not associative");
        } else {
            this.lblResultsOfAnalysis.setForeground(Color.blue);
            this.lblResultsOfAnalysis.setText("The table is a group.");
        }
    }

    public String getNextRelationship(int a, int b) {
        String relationship = JOptionPane.showInputDialog(null, "Enter the relationship for " + (char)((char)b + 97) + (char)((char)a + 97) + "\na represents group 1, b represents group 2, etc.\nA is the inverse of a, B is the inverse of b, etc.", "Relationship Dialog", 3);
        int length = relationship.length();
        if (length < 2) {
            return relationship;
        }
        for (int i = 0; i < length - 1; ++i) {
            for (int j = i + 1; j < length; ++j) {
                if (relationship.toLowerCase().charAt(i) <= relationship.toLowerCase().charAt(j)) continue;
                JOptionPane.showMessageDialog(null, "Error in relationship order.  Must order elements so that letters are in alphabetical order.", "Relationship Error", 0);
                return null;
            }
        }
        return relationship;
    }

    private boolean createNextCyclicGroup() {
        String ZnOrderString = JOptionPane.showInputDialog(null, "Enter the order for the Cyclic Group. ", "Cyclic Group Dialog", 3);
        int ZnOrder = -1;
        try {
            ZnOrder = Integer.parseInt(ZnOrderString, 10);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, ZnOrderString + " is not a legal number!\nError: " + e.getMessage(), "Number Error", 0);
            return false;
        }
        if (ZnOrder > 0) {
            if (!this.myCreator.createCyclicGroup(ZnOrder)) {
                JOptionPane.showMessageDialog(null, "Error generating a Z" + ZnOrderString + " Group.\nNO GROUP WAS GENERATED", "Group Generation Error", 0);
                return false;
            }
            this.lblResultsOfAnalysis.setText("");
            return true;
        }
        return false;
    }

    private int factorial(int n) {
        if (n <= 0) {
            return 1;
        }
        return n * this.factorial(n - 1);
    }
}

