/*
 * Decompiled with CFR 0.152.
 */
package cayleytable;

import cayleytable.groupCreator;
import cayleytable.groupMatrix;
import java.util.ArrayList;

public class groupIdentify {
    private groupMatrix identifyMatrix = new groupMatrix(0);
    private String name;
    private boolean identified;

    public groupIdentify() {
        String name = new String("emptyGroup");
        this.identified = false;
    }

    public void resetGroupIdentify(groupMatrix myGroup) {
        this.identifyMatrix.resetGroup(myGroup);
        int[] order = this.build_order_array();
        ArrayList<num_order> orderList = this.build_num_order_arrayList(order);
        this.showCenterOrders(this.computeCenter(), order);
        if (this.isCyclic(order)) {
            this.name = "Z" + Integer.toString(this.identifyMatrix.getOrder());
            this.identified = true;
        } else if (this.isTwoPrime(this.identifyMatrix.getOrder())) {
            this.name = this.identifyMatrix.getOrder() != 4 ? "D" + Integer.toString(this.identifyMatrix.getOrder() / 2) : "Klein 4";
            this.identified = true;
        } else if (this.isPrimeSqrd(this.identifyMatrix.getOrder())) {
            int root = (int)Math.round(Math.sqrt(this.identifyMatrix.getOrder()));
            this.name = "Z" + Integer.toString(root) + " x Z" + Integer.toString(root);
            this.identified = true;
        } else {
            this.name = this.identifyMatrix.checkIfCommutative() ? this.identifyAbelianXGroup(order, orderList) : this.identifyNonAbelianGroup(order, orderList);
        }
        System.out.print("Orders: ");
        for (int j = 0; j < orderList.size(); ++j) {
            num_order myOrders = orderList.get(j);
            System.out.print("\t" + myOrders.getOrderOfElement() + ": " + myOrders.getNumOfElements());
        }
        System.out.println();
    }

    public String getName() {
        return this.name;
    }

    public boolean isIdentified() {
        return this.identified;
    }

    private int[] build_order_array() {
        int[] order = new int[this.identifyMatrix.getOrder()];
        for (int i = 0; i < this.identifyMatrix.getOrder(); ++i) {
            int j = i;
            order[i] = 1;
            do {
                if (j == this.identifyMatrix.findIdentity()) continue;
                order[i] = order[i] + 1;
            } while ((j = this.identifyMatrix.getEntry(i, j)) != i);
        }
        return order;
    }

    private ArrayList<num_order> build_num_order_arrayList(int[] order) {
        ArrayList<num_order> orderList = new ArrayList<num_order>();
        for (int x = 1; x <= this.identifyMatrix.getOrder(); ++x) {
            int count = 0;
            for (int y = 0; y < this.identifyMatrix.getOrder(); ++y) {
                if (order[y] != x) continue;
                ++count;
            }
            if (count == 0) continue;
            num_order next = new num_order(x, count);
            orderList.add(next);
        }
        return orderList;
    }

    private boolean isCyclic(int[] order) {
        for (int i = 0; i < this.identifyMatrix.getOrder(); ++i) {
            if (order[i] != this.identifyMatrix.getOrder()) continue;
            return true;
        }
        return false;
    }

    private boolean isPrime(int n) {
        int divisor = 2;
        double max = Math.sqrt(n);
        while ((double)divisor <= max) {
            if (n % divisor == 0) {
                return false;
            }
            ++divisor;
        }
        return true;
    }

    private boolean isTwoPrime(int n) {
        if (n % 2 == 0) {
            return this.isPrime(n / 2);
        }
        return false;
    }

    private boolean isPrimeSqrd(int n) {
        int root = (int)Math.round(Math.sqrt(n));
        if (n == root * root) {
            return this.isPrime(root);
        }
        return false;
    }

    private String identifyAbelianXGroup(int[] order, ArrayList<num_order> orderList) {
        int max_order = 0;
        for (int i = 0; i < this.identifyMatrix.getOrder(); ++i) {
            if (order[i] <= max_order) continue;
            max_order = order[i];
        }
        int temp = this.identifyMatrix.getOrder() / max_order;
        ArrayList<factorType> factors = this.primeFactor(temp);
        Object name = new String("");
        for (int j = 0; j < factors.size(); ++j) {
            factorType nextFactor = factors.get(j);
            if (nextFactor.getNumOfPrimes() == 1) {
                name = (String)name + "Z" + Integer.toString(nextFactor.getPrime()) + " x ";
                continue;
            }
            temp = this.numElementsOfOrder(orderList, nextFactor.getPrime()) + 1;
            ArrayList<factorType> tempFactors = this.primeFactor(temp);
            factorType nextTempFactor = tempFactors.get(j);
            temp = nextTempFactor.getNumOfPrimes() - 1;
            name = (String)name + this.generateUniqueFactor(nextFactor, temp);
        }
        name = (String)name + "Z" + Integer.toString(max_order);
        this.identified = true;
        return name;
    }

    private ArrayList<factorType> primeFactor(int n) {
        ArrayList<factorType> factors = new ArrayList<factorType>();
        int i = 2;
        while (n > 1) {
            factorType nextFactor = new factorType(i, 0);
            while (n % i == 0) {
                nextFactor.incrementNumOfPrimes();
                n /= i;
            }
            if (nextFactor.getNumOfPrimes() > 0) {
                factors.add(nextFactor);
            }
            ++i;
            while (!this.isPrime(i)) {
                ++i;
            }
        }
        return factors;
    }

    private int numElementsOfOrder(ArrayList<num_order> orderList, int k) {
        for (int i = 0; i < orderList.size(); ++i) {
            num_order nextOrder = orderList.get(i);
            if (nextOrder.getOrderOfElement() != k) continue;
            return nextOrder.getNumOfElements();
        }
        return 0;
    }

    private String generateUniqueFactor(factorType nextFactor, int terms) {
        int[] xTermArray = new int[terms];
        int index = terms;
        Object name = new String("");
        for (int i = 0; i < terms; ++i) {
            xTermArray[i] = 1;
        }
        for (int j = 0; j < nextFactor.getNumOfPrimes(); ++j) {
            xTermArray[--index] = xTermArray[index] * nextFactor.getPrime();
            if (index != 0) continue;
            index = terms;
        }
        for (int k = 0; k < terms; ++k) {
            name = (String)name + "Z" + Integer.toString(xTermArray[k]) + " x ";
        }
        return name;
    }

    private String identifyNonAbelianGroup(int[] order, ArrayList<num_order> orderList) {
        Object name = new String("");
        this.identified = true;
        switch (this.identifyMatrix.getOrder()) {
            case 8: {
                if (this.numElementsOfOrder(orderList, 4) == 6) {
                    name = "Quaternion";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 4) == 2) {
                    name = "D4";
                    break;
                }
                this.identified = false;
                name = "ERROR - order 8";
                break;
            }
            case 12: {
                if (this.numElementsOfOrder(orderList, 2) == 7) {
                    name = "D6";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 3) == 8) {
                    name = "A4";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 3) == 2) {
                    name = "<2,2,3>";
                    break;
                }
                this.identified = false;
                name = "ERROR - order 12";
                break;
            }
            case 16: {
                if (this.numElementsOfOrder(orderList, 2) == 9) {
                    name = "D8";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 11) {
                    name = "Z2 x D4";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 1) {
                    name = "Q4";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 8) == 8) {
                    name = "Z2 xo Z8";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 5) {
                    name = "Z2 xi Z8";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 7) {
                    if (this.centerIsKlein4(this.computeCenter(), order)) {
                        name = "Weird2";
                        break;
                    }
                    name = "Weird1";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 4) == 12) {
                    if (this.subGroupsAllNormal()) {
                        name = "Z2 x Quaternion";
                        break;
                    }
                    name = "Z4 xo Z4";
                    break;
                }
                this.identified = false;
                name = "ERROR - order 16";
                break;
            }
            case 18: {
                if (this.numElementsOfOrder(orderList, 2) == 9 && this.numElementsOfOrder(orderList, 3) == 2) {
                    name = "D9";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 9 && this.numElementsOfOrder(orderList, 3) == 8) {
                    name = "((3,3,3;2))";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 3) {
                    name = "Z3 x D3";
                    break;
                }
                this.identified = false;
                name = "ERROR - order 18";
                break;
            }
            case 20: {
                if (this.numElementsOfOrder(orderList, 2) == 11) {
                    name = "D10";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 1) {
                    name = "<2,2,5>";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 5) {
                    name = "K-Metacyclic (20)";
                    break;
                }
                this.identified = false;
                name = "ERROR - order 20";
                break;
            }
            case 21: {
                if (this.numElementsOfOrder(orderList, 3) == 14) {
                    name = "Z3 xo Z7";
                    break;
                }
                this.identified = false;
                name = "ERROR - order 21";
                break;
            }
            case 24: {
                if (this.numElementsOfOrder(orderList, 2) == 13) {
                    name = "D12";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 6) == 8 && this.numElementsOfOrder(orderList, 2) == 7) {
                    name = "Z2 x A4";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 15) {
                    name = "Z2 x D6";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 5) {
                    name = "Z3 x D4";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 12) == 12) {
                    name = "Z3 x Quaternion";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 4) == 8) {
                    name = "Z4 x D3";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 4) == 12) {
                    name = "Z2 x <2,2,3>";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 9 && this.numElementsOfOrder(orderList, 3) == 2) {
                    name = "(4,6|2,2)";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 9 && this.numElementsOfOrder(orderList, 3) == 8) {
                    name = "S4";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 1 && this.numElementsOfOrder(orderList, 6) == 8) {
                    name = "<2,3,3>";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 4) == 14) {
                    name = "<2,2,6>";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 8) == 12) {
                    name = "<-2,2,3>";
                    break;
                }
                this.identified = false;
                name = "ERROR - order 24";
                break;
            }
            case 27: {
                if (this.numElementsOfOrder(orderList, 3) == 26) {
                    name = "(3,3|3,3)";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 3) == 8) {
                    name = "Weird 27";
                    break;
                }
                this.identified = false;
                name = "ERROR - order 27";
                break;
            }
            case 28: {
                if (this.numElementsOfOrder(orderList, 2) == 15) {
                    name = "D14";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 1) {
                    name = "<2,2,7>";
                    break;
                }
                this.identified = false;
                name = "ERROR - order 28";
                break;
            }
            case 30: {
                if (this.numElementsOfOrder(orderList, 2) == 15) {
                    name = "D15";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 5) {
                    name = "Z3 x D5";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 3) {
                    name = "Z5 x D3";
                    break;
                }
                this.identified = false;
                name = "ERROR - order 30";
                break;
            }
            case 32: {
                this.showCenterOrders(this.computeCenter(), order);
                if (this.subGroupsAllNormal()) {
                    System.out.println("All Normal");
                } else {
                    System.out.println("Not All Normal:");
                }
                if (this.numElementsOfOrder(orderList, 2) == 23) {
                    name = "Z2 x Z2 x D4 - Hall Senior Number 8 for Order 32";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 16) == 16) {
                    name = "Z16 xo Z2 - Hall Senior Number 22 for Order 32";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 19 && this.numElementsOfOrder(orderList, 8) == 8) {
                    name = "Z2 x D8 - Hall Senior Number 23 for Order 32";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 8) == 24) {
                    name = "Hall Senior Number 32 for Order 32";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 15 && this.determineInnerAutomorphism().trim().equalsIgnoreCase("Z2 x Z2 x Z2")) {
                    name = "Hall Senior Number 36 for Order 32";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 14) {
                    name = "Hall Senior Number 42 for Order 32";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 15 && this.numElementsOfOrder(orderList, 8) == 8) {
                    name = "Hall Senior Number 44 for Order 32";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 11 && this.numElementsOfOrder(orderList, 4) == 4) {
                    name = "Hall Senior Number 47 for Order 32";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 17) {
                    name = "D16 - Hall Senior Number 49 for Order 32";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 2) == 9) {
                    name = "Z16 xi Z2 - Hall Senior Number 50 for Order 32";
                    break;
                }
                if (this.numElementsOfOrder(orderList, 4) == 18) {
                    name = "<2, 2, 8> - Hall Senior Number 51 for Order 32";
                    break;
                }
                this.identified = false;
                name = "ERROR Unknown group name - order 32";
                break;
            }
            default: {
                name = "ERROR - order " + Integer.toString(this.identifyMatrix.getOrder());
                this.identified = false;
            }
        }
        return name;
    }

    private ArrayList<Integer> computeCenter() {
        ArrayList<Integer> center_list = new ArrayList<Integer>();
        center_list.add(this.identifyMatrix.findIdentity());
        for (int row = 0; row < this.identifyMatrix.getOrder(); ++row) {
            if (row == this.identifyMatrix.findIdentity()) continue;
            boolean commutes = true;
            for (int col = 1; commutes && col < this.identifyMatrix.getOrder(); ++col) {
                if (this.identifyMatrix.getEntry(row, col) == this.identifyMatrix.getEntry(col, row)) continue;
                commutes = false;
            }
            if (!commutes) continue;
            center_list.add(row);
            System.out.println("Center contains: " + row);
        }
        return center_list;
    }

    private boolean centerIsKlein4(ArrayList<Integer> center_list, int[] order) {
        if (center_list.size() != 4) {
            return false;
        }
        for (int count = 1; count <= 3; ++count) {
            Integer element = center_list.get(count);
            if (order[element] == 2) continue;
            return false;
        }
        return true;
    }

    private void showCenterOrders(ArrayList<Integer> center_list, int[] order) {
        System.out.print("Center: ");
        for (int count = 0; count < center_list.size(); ++count) {
            Integer element = center_list.get(count);
            System.out.print("\telmt " + element + ": " + order[element]);
        }
        System.out.println();
    }

    private boolean subGroupsAllNormal() {
        for (int i = 0; i < this.identifyMatrix.getOrder(); ++i) {
            ArrayList<Integer> sgList = this.generateSubGroupList(i);
            if (this.normal(sgList)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<Integer> generateSubGroupList(int element) {
        ArrayList<Integer> subGroupList = new ArrayList<Integer>();
        subGroupList.add(this.identifyMatrix.findIdentity());
        int temp = element;
        while (temp != this.identifyMatrix.findIdentity()) {
            subGroupList.add(temp);
            temp = this.identifyMatrix.getEntry(temp, element);
        }
        return subGroupList;
    }

    private boolean normal(ArrayList<Integer> subGroupList) {
        for (int i = 0; i < this.identifyMatrix.getOrder(); ++i) {
            ArrayList<Integer> tempSet = new ArrayList<Integer>();
            int inverse = this.identifyMatrix.findInverse(i);
            for (int j = 0; j < subGroupList.size(); ++j) {
                Integer tempCol = subGroupList.get(j);
                int tempRow = this.identifyMatrix.getEntry(i, tempCol);
                tempSet.add(this.identifyMatrix.getEntry(tempRow, inverse));
            }
            for (int k = 0; k < subGroupList.size(); ++k) {
                boolean inSet = false;
                for (int t = 0; t < tempSet.size(); ++t) {
                    if (((Integer)tempSet.get(t)).intValue() != subGroupList.get(k).intValue()) continue;
                    inSet = true;
                }
                if (inSet) continue;
                return false;
            }
        }
        return true;
    }

    private String determineInnerAutomorphism() {
        groupCreator localCreator = new groupCreator();
        localCreator.resetGroup(this.identifyMatrix);
        if (localCreator.createInnerAutGroup()) {
            groupIdentify innerAutName = new groupIdentify();
            innerAutName.resetGroupIdentify(localCreator.getGroup());
            if (innerAutName.isIdentified()) {
                return innerAutName.getName();
            }
        }
        return null;
    }

    private class num_order {
        private int orderOfElement;
        private int numOfElements;

        public num_order(int order, int num) {
            this.orderOfElement = order;
            this.numOfElements = num;
        }

        public int getOrderOfElement() {
            return this.orderOfElement;
        }

        public int getNumOfElements() {
            return this.numOfElements;
        }
    }

    private class factorType {
        private int prime;
        private int numOfPrimes;

        public factorType(int p, int num) {
            this.prime = p;
            this.numOfPrimes = num;
        }

        public int getPrime() {
            return this.prime;
        }

        public int getNumOfPrimes() {
            return this.numOfPrimes;
        }

        public void incrementNumOfPrimes() {
            ++this.numOfPrimes;
        }
    }
}

