/*
 * Decompiled with CFR 0.152.
 */
package cayleytable;

import cayleytable.groupMatrix;
import cayleytable.groupRelation;
import java.util.ArrayList;

public class groupCreator {
    private groupMatrix group;

    public groupCreator() {
        this.group = new groupMatrix(0);
    }

    public groupCreator(int size) {
        this.group = new groupMatrix(size);
    }

    public groupMatrix getGroup() {
        return this.group;
    }

    public boolean resetGroup(groupMatrix newGroup) {
        if (this.group.getOrder() != newGroup.getOrder()) {
            this.group.resetSize(newGroup.getOrder());
        }
        for (int row = 0; row < this.group.getOrder(); ++row) {
            for (int col = 0; col < this.group.getOrder(); ++col) {
                this.group.setEntry(row, col, newGroup.getEntry(row, col));
            }
        }
        return this.group.checkComplete();
    }

    public boolean createEmptyGroup(int size) {
        int order = this.group.getOrder();
        if (order != size) {
            this.group.resetSize(size);
        }
        return this.group.checkComplete();
    }

    public boolean createCyclicGroup(int size) {
        int order = this.group.getOrder();
        if (order != size) {
            this.group.resetSize(size);
        }
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                this.group.setEntry(row, col, (row + col) % size);
            }
        }
        return this.group.checkComplete();
    }

    public boolean createXProdGroup(groupMatrix g1, groupMatrix g2) {
        int size = g1.getOrder() * g2.getOrder();
        if (size != this.group.getOrder()) {
            this.group.resetSize(size);
        }
        int[][] cross_prod_set = new int[size][2];
        int count = 0;
        for (int i = 0; i < g1.getOrder(); ++i) {
            int j = 0;
            while (j < g2.getOrder()) {
                cross_prod_set[count][0] = i;
                cross_prod_set[count][1] = j++;
                ++count;
            }
        }
        if (count != size) {
            return false;
        }
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                int x1 = cross_prod_set[row][0];
                int x2 = cross_prod_set[col][0];
                int x = g1.getEntry(x1, x2);
                int y1 = cross_prod_set[row][1];
                int y2 = cross_prod_set[col][1];
                int y = g2.getEntry(y1, y2);
                boolean found = false;
                for (int k = 0; k < size && !found; ++k) {
                    if (x != cross_prod_set[k][0] || y != cross_prod_set[k][1]) continue;
                    found = true;
                    this.group.setEntry(row, col, k);
                }
                if (found) continue;
                return false;
            }
        }
        return this.group.checkComplete();
    }

    public boolean createDefineRelationGroup(ArrayList<String> generatorList, ArrayList<groupRelation> relationships) {
        int size = 1;
        for (int i = 0; i < generatorList.size(); ++i) {
            size *= Integer.parseInt(generatorList.get(i));
        }
        if (size != this.group.getOrder()) {
            this.group.resetSize(size);
        }
        ArrayList finalElements = this.createFinalElementList(generatorList);
        for (int row = 0; row < finalElements.size(); ++row) {
            for (int col = 0; col < finalElements.size(); ++col) {
                String tempWord = new String((String)finalElements.get(row) + (String)finalElements.get(col));
                boolean stillReducing = true;
                while (stillReducing) {
                    boolean substMade = false;
                    for (int k = 0; k < relationships.size() && !substMade; ++k) {
                        groupRelation curRelation = relationships.get(k);
                        int loc = tempWord.indexOf(curRelation.getLeft());
                        StringBuffer tempBuffer = new StringBuffer(tempWord);
                        if (loc < 0) continue;
                        tempBuffer.replace(loc, loc + curRelation.getLeft().length(), curRelation.getRight());
                        tempWord = tempBuffer.toString();
                        substMade = true;
                    }
                    if (substMade) continue;
                    stillReducing = false;
                }
                int count = 0;
                boolean elementFound = false;
                while (!elementFound && count < finalElements.size()) {
                    String tempFinal = (String)finalElements.get(count);
                    if (tempWord.trim().compareTo(tempFinal.trim()) == 0) {
                        this.group.setEntry(row, col, count);
                        elementFound = true;
                    }
                    if (elementFound) continue;
                    ++count;
                }
                if (elementFound) continue;
                return false;
            }
        }
        return this.group.checkComplete();
    }

    private ArrayList createFinalElementList(ArrayList<String> generatorList) {
        ArrayList<String> finalElements = new ArrayList<String>();
        int size = generatorList.size();
        String str = new String("");
        int[] gens = new int[size];
        ArrayList<ArrayList<String>> elementMatrix = new ArrayList<ArrayList<String>>();
        for (int i = 0; i < size; ++i) {
            str = "";
            ArrayList<String> elementRow = new ArrayList<String>();
            for (int j = 0; j < Integer.parseInt(generatorList.get(i)); ++j) {
                elementRow.add(str);
                str = Integer.toString(i);
            }
            elementMatrix.add(elementRow);
        }
        int count = 0;
        String lastElement = new String("");
        Object nextElement = new String("");
        for (int k = 0; k < Integer.parseInt(generatorList.get(count)); ++k) {
            ArrayList elementRow = (ArrayList)elementMatrix.get(count);
            nextElement = (String)nextElement + (String)elementRow.get(k);
            finalElements = this.fillList(finalElements, elementMatrix, generatorList, (String)nextElement, count + 1);
        }
        return finalElements;
    }

    private ArrayList<String> fillList(ArrayList<String> finalElements, ArrayList<ArrayList<String>> elementMatrix, ArrayList<String> generatorList, String nextElement, int count) {
        if (count >= generatorList.size()) {
            finalElements.add((String)nextElement);
        } else {
            for (int i = 0; i < Integer.parseInt(generatorList.get(count)); ++i) {
                ArrayList<String> elementRow = elementMatrix.get(count);
                nextElement = (String)nextElement + elementRow.get(i);
                finalElements = this.fillList(finalElements, elementMatrix, generatorList, (String)nextElement, count + 1);
            }
        }
        return finalElements;
    }

    public boolean createInnerAutGroup() {
        int order = this.group.getOrder();
        ArrayList<groupMatrix> innerGroups = new ArrayList<groupMatrix>();
        int innerGroupCount = 0;
        int[] groupPosn = new int[order];
        for (int g = 0; g < order; ++g) {
            boolean inList = false;
            groupMatrix tempGroup = this.createInnerAutFromElement(g);
            if (g != 0) {
                for (int i = 0; i < innerGroups.size(); ++i) {
                    groupMatrix listGroup = (groupMatrix)innerGroups.get(i);
                    if (!listGroup.isEqual(tempGroup)) continue;
                    inList = true;
                }
            }
            if (inList) continue;
            groupPosn[innerGroupCount++] = g;
            innerGroups.add(tempGroup);
        }
        groupMatrix nextGroup = new groupMatrix(innerGroups.size());
        for (int row = 0; row < innerGroups.size(); ++row) {
            for (int col = 0; col < innerGroups.size(); ++col) {
                groupMatrix tempGroup = this.createInnerAutFromTwoElements(groupPosn[row], groupPosn[col]);
                for (int i = 0; i < innerGroups.size(); ++i) {
                    groupMatrix listGroup = (groupMatrix)innerGroups.get(i);
                    if (!listGroup.isEqual(tempGroup)) continue;
                    nextGroup.setEntry(row, col, i);
                }
            }
        }
        if (nextGroup.checkComplete()) {
            this.group.resetGroup(nextGroup);
            return true;
        }
        return false;
    }

    public groupMatrix createInnerAutFromTwoElements(int elmtA, int elmtB) {
        int order = this.group.getOrder();
        groupMatrix tempGrp = new groupMatrix(order);
        int invA = -1;
        int invB = -1;
        int identity = this.group.findIdentity();
        if (identity == -1) {
            return tempGrp;
        }
        for (int i = 0; i < order; ++i) {
            if (this.group.getEntry(elmtA, i) == identity) {
                invA = i;
            }
            if (this.group.getEntry(elmtB, i) != identity) continue;
            invB = i;
        }
        if (invA == -1 || invB == -1) {
            return tempGrp;
        }
        for (int row = 0; row < order; ++row) {
            for (int col = 0; col < order; ++col) {
                tempGrp.setEntry(row, col, this.group.getEntry(this.group.getEntry(elmtA, this.group.getEntry(this.group.getEntry(elmtB, this.group.getEntry(row, col)), invB)), invA));
            }
        }
        return tempGrp;
    }

    public groupMatrix createInnerAutFromElement(int element) {
        int order = this.group.getOrder();
        groupMatrix tempGrp = new groupMatrix(order);
        int inverse = -1;
        int identity = this.group.findIdentity();
        if (identity == -1) {
            return tempGrp;
        }
        for (int i = 0; i < order; ++i) {
            if (this.group.getEntry(element, i) != identity) continue;
            inverse = i;
            break;
        }
        if (inverse == -1) {
            return tempGrp;
        }
        for (int row = 0; row < order; ++row) {
            for (int col = 0; col < order; ++col) {
                tempGrp.setEntry(row, col, this.group.getEntry(this.group.getEntry(element, this.group.getEntry(row, col)), inverse));
            }
        }
        return tempGrp;
    }
}

